#include <iostream>
#include <unordered_map>
#include <vector>
using namespace std;

int main() {
    int N;
    cin >> N;
    vector<pair<int, int>> points(N);
    for (int i = 0; i < N; i++) {
        cin >> points[i].first >> points[i].second;
    }

    long long result = 0;

    unordered_map<int, int> count_even_x, count_odd_x;
    for (auto& p : points) {
        int x = p.first, y = p.second;
        if (x % 2 == 0) count_even_x[y]++;
        else count_odd_x[y]++;
    }
    for (auto& entry : count_even_x) {
        long long p = entry.second;
        result += p * (p - 1) / 2;
    }
    for (auto& entry : count_odd_x) {
        long long n = entry.second;
        result += n * (n - 1) / 2;
    }

    unordered_map<int, int> count_even_y, count_odd_y;
    for (auto& p : points) {
        int x = p.first, y = p.second;
        if (y % 2 == 0) count_even_y[x]++;
        else count_odd_y[x]++;
    }
    for (auto& entry : count_even_y) {
        long long p = entry.second;
        result += p * (p - 1) / 2;
    }
    for (auto& entry : count_odd_y) {
        long long n = entry.second;
        result += n * (n - 1) / 2;
    }

    unordered_map<long long, int> count_sum;
    for (auto& p : points) {
        long long s = (long long)p.first + p.second;
        count_sum[s]++;
    }
    for (auto& entry : count_sum) {
        long long k = entry.second;
        result += k * (k - 1);
    }

    unordered_map<long long, int> count_diff;
    for (auto& p : points) {
        long long d = (long long)p.first - p.second;
        count_diff[d]++;
    }
    for (auto& entry : count_diff) {
        long long k = entry.second;
        result += k * (k - 1);
    }

    cout << result << endl;

    return 0;
}